/*
 iMedia Browser Framework <http://karelia.com/imedia/>
 
 Copyright (c) 2005-2012 by Karelia Software et al.
 
 iMedia Browser is based on code originally developed by Jason Terhorst,
 further developed for Sandvox by Greg Hulands, Dan Wood, and Terrence Talbot.
 The new architecture for version 2.0 was developed by Peter Baumgartner.
 Contributions have also been made by Matt Gough, Martin Wennerberg and others
 as indicated in source files.
 
 The iMedia Browser Framework is licensed under the following terms:
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in all or substantial portions of the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish,
 distribute, sublicense, and/or sell copies of the Software, and to permit
 persons to whom the Software is furnished to do so, subject to the following
 conditions:
 
	Redistributions of source code must retain the original terms stated here,
	including this list of conditions, the disclaimer noted below, and the
	following copyright notice: Copyright (c) 2005-2012 by Karelia Software et al.
 
	Redistributions in binary form must include, in an end-user-visible manner,
	e.g., About window, Acknowledgments window, or similar, either a) the original
	terms stated here, including this list of conditions, the disclaimer noted
	below, and the aforementioned copyright notice, or b) the aforementioned
	copyright notice and a link to karelia.com/imedia.
 
	Neither the name of Karelia Software, nor Sandvox, nor the names of
	contributors to iMedia Browser may be used to endorse or promote products
	derived from the Software without prior and express written permission from
	Karelia Software or individual contributors, as appropriate.
 
 Disclaimer: THE SOFTWARE IS PROVIDED BY THE COPYRIGHT OWNER AND CONTRIBUTORS
 "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
 LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 LIABLE FOR ANY CLAIM, DAMAGES, OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 CONTRACT, TORT, OR OTHERWISE, ARISING FROM, OUT OF, OR IN CONNECTION WITH, THE
 SOFTWARE OR THE USE OF, OR OTHER DEALINGS IN, THE SOFTWARE.
 */


// Author: Jörg Jacobsen


//----------------------------------------------------------------------------------------------------------------------

#import "IMBObjectViewController.h"
#import "IMBNodeObject.h"

#pragma mark ABSTRACT

// The skimmable object view controller retrieves some node object specific information
// from its delegate. The reason why we do not implement this protocol directly on the node object class itself
// is that it may be stored in a format (eg. some sub node from a parser's property list) which is better suited
// for the parser to be evaluated when needed (lazy evaluation).
// Nonetheless, the IMBNodeObject may hold this information for the parser (IMBNodeObject.attributes).
// See IMBiPhotoParser for an implementation of the protocol.
 
@protocol IMBSkimmableObjectViewControllerDelegate <NSObject>

- (NSUInteger) childrenCountOfNodeObject:(IMBNodeObject*)inNodeObject userInfo:(NSDictionary*)inUserInfo;

- (NSString*) imagePathForChildOfNodeObject:(IMBNodeObject*)inNodeObject atIndex:(NSUInteger)inIndex userInfo:(NSDictionary*)inUserInfo;

- (NSString*) imagePathForKeyChildOfNodeObject:(IMBNodeObject*)inNodeObject userInfo:(NSDictionary*)inUserInfo;

@end

#pragma mark ABSTRACT

// This is the designated object view controller class for any icon view that wants to expose
// skimmable images (like iPhoto events). You may subclass (see IMBiPhotoEventObjectViewController
// for an example).
//
// Since this controller class is a "custom object view controller" class in terms of iMedia
// do NOT store it in the array of the panel controller where the other object view controllers
// are reused from (one per media type), because then we would have two controllers in there
// for the same media type "image".

@interface IMBSkimmableObjectViewController : IMBObjectViewController {

	NSUInteger _previousNodeObjectIndex;	// Index of node object the mouse was over on last mouse move
	NSUInteger _previousImageIndex;			// Index of image in node object that was last displayed when skimming
	id <IMBSkimmableObjectViewControllerDelegate> _skimmingDelegate;
	NSDictionary* _userInfo;
}

@property(retain, readwrite) id <IMBSkimmableObjectViewControllerDelegate> skimmingDelegate;

- (id) initWithDelegate:(id <IMBSkimmableObjectViewControllerDelegate>)inDelegate userInfo:(NSDictionary*)inUserInfo;

@end
